
#include <Liquid_Crystal.h>       //Άνοιγμα βιβλιοθήκης για την οθόνη
#include <Potentiometer.h>        //Άνοιγμα βιβλιοθήκης για το ποτενσιόμετρο


LiquidCrystal myLCD(0x27, 16, 2);// H Διεύθυνση της οθόνης LCD (Η οθόνη LCD πρέπει να συνδεθεί στην θύρα I2C του Arduino)


int potPort = A0;                // Ορισμός της θύρας του ποτενσιόμετρου (Επιλέγουμε αναλογική θύρα για τη σύνδεση του ποτενσιόμετρου)


float potMin = -10.0;           // Δήλωση μεταβλητής potMin και ορισμός της τιμής της. Είναι η ελάχιστη τιμή που μπορεί να πάρει το ποτενσιόμετρο (για 0V)
float potMax = 10.0;            //Δήλωση μεταβλητής potMax και ορισμός της τιμής της. Είναι η μέγιστη τιμή που μπορεί να πάρει το ποτενσιόμετρο   (για 5V)
float calibration=0.0;          // Δήλωση μεταβλητής calibration όπου θα αποθηκευτεί παρακάτω στον κώδικα η τιμή του ποτενσιόμετρου. Θα είναι μια τιμή μεταξύ potMin και potMax


Potentiometer myPot(potPort, potMin, potMax);    // Έναρξη του ποτενσιόμετρου 

void setup() 
{
  myLCD.begin();    //Έναρξη της οθόνης LCD
}

void loop() 
{

  calibration = myPot.read();  // Ανάγνωση της τιμής του ποτενσιόμετρου και αποθήκευση στην μεταβλητή calibration
  myLCD.Text("Pot =          ", 0, 0); // Εμφάνιση κειμένου στην οθόνη από την στήλη 1 και την γραμμή 1
  
  myLCD.Text(String(calibration,1).c_str(), 5, 0); // Εμφάνιση της τιμής της μεταβλητής calibration (τιμή ποτενσίομετρου) με ένσ δεκαδικό ψηφίο
  
  delay(200);
}
